/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fionathemortal.betterbiomeblend.common.cache;

import java.util.concurrent.atomic.AtomicInteger;

public abstract class Slice {
    public long key;
    public int size;
    public int salt;
    public AtomicInteger refCount = new AtomicInteger();

    public Slice(int size, int salt) {
        this.size = size;
        this.salt = salt;
        this.markAsInvalid();
    }

    public abstract void invalidateData();

    public final int getRefCount() {
        int result = this.refCount.get();
        return result;
    }

    public final void release() {
        this.refCount.decrementAndGet();
    }

    public final void acquire() {
        this.refCount.incrementAndGet();
    }

    public final boolean isInvalid() {
        boolean result = (this.key ^ (long)this.salt) == -1L;
        return result;
    }

    public final void markAsInvalid() {
        this.key = 0xFFFFFFFF ^ this.salt;
    }
}

